***************************************
***** Code to take markup esitamtes and estiamte superlasticities - time varying
***** From Hambur and Freestone 2025 - How Costly are Markups in Australia
** Takes markup estiamtes from other work, as noted in readme files
**************************************

** Preliminaries
local data ""
local outputs ""
sysdir set PLUS ""
mata: mata mlib index
local ind industry // verion of markup estimation
local file _bit // verion of markup estimation

local output income // sales variable

local input variable2 // inut varaibles

global mu m_DLW_tl_m_w_y // markup versuion 
global ind industry // verion of markup estimation

** Current Current (0) or lagged book value of K stock, or perp inv est (2)
local k_meas = 1

* Define the instrument sets
local k_instr k

**** Trim extreme growth? no (0), if large share of industry change (1), if in outlier in distry (2), based multiprod rules
local trm = 0

local drops 1

local cuts 1


****** Load in file

** loop over potnetial trimming approaches
foreach trim in  iy_w  iy95_w {
	use "`outputs'\mark_k_`k_meas'_instr_`k_instr'_out_`output'_int_`input'_trm_`trm'_`ind'_`file'_l`cuts'.dta" ,	 clear
	rename  markup_DLW_tl_m_w_y m_DLW_tl_m_w_y // simplify name

	** Labour based markups using simple cost share approach

** weighted  
 bysort fyear industry: g lab_tot = sum(labour)
 bysort fyear industry: g var_tot = sum(variable1)
  g elast_y = lab_tot/var_tot // annual elasticity (or share)
 bysort industry: egen elast = mean(elast_y) //sample average elasticity (or share)
 
 
g  markup_w_y = Y_nom/labour*elast_y
g  markup_w = Y_nom/labour*elast


** Int based markups using simple cost share approach

** weighted  
 bysort fyear industry: g var2_tot = sum(variable2)
  g elast_y_m = var2_tot/var_tot // annual elasticity (or share)
 bysort industry: egen elast_m = mean(elast_y_m) /sample average //sample average elasticity (or share)
 
 
g  markup_w_y_m = Y_nom/variable2*elast_y_m
g  markup_w_m = Y_nom/variable2*elast_m

** For each markup measure run
	foreach mu in m_DLW_tl_m_w_y markup_w_y  {
global mu `mu'
		
		*** Etimate superealsticity at the aggregate level
		
		preserve 
		
		** Int based makrups 
		g sigma = $mu /( $mu -1) 
** trimming
		drop if $mu <0
		if "`trim'" =="i" {
			bysort industry: egen mu99 =pctile( $mu ) , p(99)
			drop if $mu > mu99 
			bysort industry: egen sigma99 =pctile( sigma ) , p(99)
			drop if sigma > sigma99
		}
		
		if "`trim'" =="i_w" {
			bysort industry: egen mu99 =pctile( $mu ) , p(99)
			replace $mu = mu99 if $mu >	mu99 & $mu !=.
			bysort industry: egen sigma99 =pctile( sigma ) , p(99)
			replace sigma = sigma99 if sigma >	sigma99 & sigma !=.
		}
	
	
	if "`trim'" =="iy" {
			bysort fyear industry: egen mu99y =pctile($mu ) , p(99)
			drop if $mu >	mu99y
			bysort industry: egen sigma99 =pctile( sigma ) , p(99)
			drop if sigma > sigma99
		}
		
		if "`trim'" =="iy_w" {
			bysort fyear industry: egen mu99y =pctile($mu ) , p(99)
			replace $mu = mu99y if $mu >	mu99y & $mu !=.
			bysort industry: egen sigma99 =pctile( sigma ) , p(99)
			replace sigma = sigma99 if sigma >	sigma99 & sigma !=.
		}

		if "`trim'" =="i95" {
			bysort industry: egen mu95 =pctile( $mu ) , p(95)
			drop if $mu >	mu95 
			bysort industry: egen sigma95 =pctile( sigma ) , p(95)
			drop if sigma > sigma95
		}
		
		if "`trim'" =="i95_w" {
			bysort industry: egen mu95 =pctile( $mu ) , p(95)
			replace $mu = mu95 if $mu >	mu95 & $mu !=.
			bysort industry: egen sigma95 =pctile( sigma ) , p(95)
			replace sigma = sigma95 if sigma >	sigma95 & sigma !=.
		}
	
	
	
		if "`trim'" =="iy95" {
			bysort industry fyear: egen mu95y =pctile($mu ) , p(95)
			drop if $mu > mu95y 
			bysort fyear industry: egen sigma95 =pctile( sigma ) , p(95)
			drop if sigma > sigma95
		}
		
			
		if "`trim'" =="iy95_w" {
			bysort industry fyear: egen mu95y =pctile($mu ) , p(95)
			replace $mu = mu95y if $mu >	mu95y & $mu !=.
			bysort fyear industry: egen sigma95 =pctile( sigma ) , p(95)
			replace sigma = sigma95 if sigma >	sigma95 & sigma !=.
		}
		
		drop if $mu <=1 // no markups below 1
		** extra sigma level constraint for very high elasticities
		egen mu99_t =pctile( $mu ) , p(99)
		replace $mu = mu99_t if $mu >	2*mu99_t & $mu !=.
 		egen sigma99_t =pctile( $mu ) , p(99)
		replace sigma = mu99_t if sigma >	2*sigma99_t & sigma !=.
 
		bysort fyear industry: egen tot_y = total(Y_nom)
		bysort fyear industry: egen tot_l = total(labour)
		bysort fyear industry: egen tot_m = total(M_nom)


		

		g sales_share = Y_nom/tot_y
		g lsales_share = log(sales_share)
		
		g M_share = M_nom/tot_m
		g L_share = labour/tot_l


** functional form
		g fmu = 1/$mu +log(1-1/$mu )
		xtset firmid fyear
 
 ** Super elast regressions
 
 summari fyear
 local max = `r(max)'
 local min = `r(min)'
	local j = `max'-2
	
	g a_nfe = .
	g b_nfe = .
	g a_fe = .
	g b_fe = .
	** Looping over 3 year windows
 forvalues q = `min'/`j' {
		reghdfe fmu lsales_share if fyear>=`q' & fyear<=`q'+2, vce(cluster firmid) a(i.fyear##i.industry)
		replace a_nfe = _b[_cons] if fyear==`q'
		replace b_nfe = _b[lsales_share] if fyear==`q'

		reghdfe fmu lsales_share if fyear>=`q' & fyear<=`q'+2, vce(cluster firmid) a(i.fyear##i.industry firmid )
		replace a_fe = _b[_cons] if fyear==`q'
		replace b_fe = _b[lsales_share] if fyear==`q'
 }


** Make measures for version with and witht out FE in regression
		foreach var in nfe fe    {
			g rho_`var' = 1/(1+ $mu *b_`var')
		}

 ** Sales weighted elasticity
		g sigma_w = sigma*sales_share
		g sigma2 = sigma^2
		g sigma2_w = sigma2*sales_share

	** Passthrough coefficent	
		g rho_nfe_w = rho_nfe*sales_share
		g rho_fe_w = rho_fe*sales_share
		g rho_fe2 = rho_fe^2
		g rho_fe2_w = rho_fe2*sales_share

	
		g sig_rho_nfe_w = sigma*rho_nfe*sales_share
		g sig_rho_fe_w = sigma*rho_fe*sales_share 
		
		g sig_rho_nfe = sigma*rho_nfe
		g sig_rho_fe = sigma*rho_fe 
		
	** Weighted markups	
		g wy_$mu = $mu * sales_share
		g wm_$mu = $mu * M_share
	** harmonic	
		g hwy_$mu = (1/ $mu ) * sales_share
		
		rename b_nfe s_elast_nfe
		rename b_fe s_elast_fe
		
		bysort industry fyear: egen y_95 =pctile(Y_nom ) , p(95)
		g top_5_share= sales_share *(Y_nom>=y_95 & Y_nom!=.)
** Collapse to industry level
		collapse(sum) top_5_share sigma_w rho_nfe_w rho_fe_w sig_rho_nfe_w sig_rho_fe_w wy_$mu hwy_$mu wm_$mu Y_nom labour M_nom sigma2_w rho_fe2_w sales_share (max) max_sigma_w=sigma_w  max_rho_nfe_w=rho_nfe_w max_rho_fe_w=rho_fe_w  max_sig_rho_nfe_w=sig_rho_nfe_w max_sig_rho_fe_w=sig_rho_fe_w max_wy_$mu =wy_$mu max_hwy_$mu =hwy_$mu max_wm_$mu = wm_$mu max_Y_share = sales_share max_M_share= M_share max_labour_share = L_share (count) firmid  (mean) $mu s_elast_nfe s_elast_fe sigma rho_nfe rho_fe sig_rho_nfe sig_rho_fe (p50) med_$mu = $mu med_sigma = sigma, by(fyear $ind )
 
		g cov_nfe = sig_rho_nfe_w-sigma_w*rho_nfe_w
		g cov_fe = sig_rho_fe_w-sigma_w*rho_fe_w
		
		g var_sigma = sigma2_w-sigma_w^2
		g var_rho_fe = rho_fe2_w-rho_fe_w^2
		
		g sd_sigma = var_sigma^(1/2)
		g sd_rho_fe = var_rho_fe^(1/2)
		
		g cor_fe = cov_fe/(sd_sigma*sd_rho_fe)
		
		replace hwy_$mu = 1/hwy_$mu
		
		save "`outputs'\agg_pass_trim_`trim'_`mu'_2024_tv.dta"  , replace  
		restore
		*** Division level estiamtion,  as above
		levelsof divno , local(ind_names)

	foreach i in   `ind_names' {
	
		
		preserve 

		drop if divno != `i'

	
		** Int based
		g sigma = $mu /( $mu -1) 

		drop if $mu <0
		if "`trim'" =="i" {
			bysort industry: egen mu99 =pctile( $mu ) , p(99)
			drop if $mu > mu99 
			bysort industry: egen sigma99 =pctile( sigma ) , p(99)
			drop if sigma > sigma99
		}
		
		if "`trim'" =="i_w" {
			bysort industry: egen mu99 =pctile( $mu ) , p(99)
			replace $mu = mu99 if $mu >	mu99 & $mu !=.
			bysort industry: egen sigma99 =pctile( sigma ) , p(99)
			replace sigma = sigma99 if sigma >	sigma99 & sigma !=.
		}
	
	
	if "`trim'" =="iy" {
			bysort fyear industry: egen mu99y =pctile($mu ) , p(99)
			drop if $mu >	mu99y
			bysort industry: egen sigma99 =pctile( sigma ) , p(99)
			drop if sigma > sigma99
		}
		
		if "`trim'" =="iy_w" {
			bysort fyear industry: egen mu99y =pctile($mu ) , p(99)
			replace $mu = mu99y if $mu >	mu99y & $mu !=.
			bysort industry: egen sigma99 =pctile( sigma ) , p(99)
			replace sigma = sigma99 if sigma >	sigma99 & sigma !=.
		}

		if "`trim'" =="i95" {
			bysort industry: egen mu95 =pctile( $mu ) , p(95)
			drop if $mu >	mu95 
			bysort industry: egen sigma95 =pctile( sigma ) , p(95)
			drop if sigma > sigma95
		}
		
		if "`trim'" =="i95_w" {
			bysort industry: egen mu95 =pctile( $mu ) , p(95)
			replace $mu = mu95 if $mu >	mu95 & $mu !=.
			bysort industry: egen sigma95 =pctile( sigma ) , p(95)
			replace sigma = sigma95 if sigma >	sigma95 & sigma !=.
		}
	
	
	
		if "`trim'" =="iy95" {
			bysort industry fyear: egen mu95y =pctile($mu ) , p(95)
			drop if $mu > mu95y 
			bysort fyear industry: egen sigma95 =pctile( sigma ) , p(95)
			drop if sigma > sigma95
		}
		
			
		if "`trim'" =="iy95_w" {
			bysort industry fyear: egen mu95y =pctile($mu ) , p(95)
			replace $mu = mu95y if $mu >	mu95y & $mu !=.
			bysort fyear industry: egen sigma95 =pctile( sigma ) , p(95)
			replace sigma = sigma95 if sigma >	sigma95 & sigma !=.
		}
		
		drop if $mu <=1
		** extra sigma level constraint for crazy high
		egen mu99_t =pctile( $mu ) , p(99)
		replace $mu = mu99_t if $mu >	2*mu99_t & $mu !=.
 		egen sigma99_t =pctile( $mu ) , p(99)
		replace sigma = mu99_t if sigma >	2*sigma99_t & sigma !=.
 
	
 
 
		bysort fyear industry: egen tot_y = total(Y_nom)
		bysort fyear industry: egen tot_l = total(labour)
		bysort fyear industry: egen tot_m = total(M_nom)



		g sales_share = Y_nom/tot_y
		g lsales_share = log(sales_share)
		
		
		
		g M_share = M_nom/tot_m
		g L_share = labour/tot_l




		g fmu = 1/$mu +log(1-1/$mu )
		xtset firmid fyear
 
 ** base
 summari fyear
 local max = `r(max)'
 local min = `r(min)'
	local j = `max'-2
	
	g a_nfe = .
	g b_nfe = .
	g a_fe = .
	g b_fe = .
 forvalues q = `min'/`j' {
		reghdfe fmu lsales_share if fyear>=`q' & fyear<=`q'+2, vce(cluster firmid) a(i.fyear##i.industry)
		replace a_nfe = _b[_cons] if fyear==`q'
		replace b_nfe = _b[lsales_share] if fyear==`q'

		reghdfe fmu lsales_share if fyear>=`q' & fyear<=`q'+2, vce(cluster firmid) a(i.fyear##i.industry firmid )
		replace a_fe = _b[_cons] if fyear==`q'
		replace b_fe = _b[lsales_share] if fyear==`q'
 }



		foreach var in nfe fe    {
			g rho_`var' = 1/(1+ $mu *b_`var')
		}

 
		g sigma_w = sigma*sales_share
		g sigma2 = sigma^2
		g sigma2_w = sigma2*sales_share
		
		g rho_nfe_w = rho_nfe*sales_share
		g rho_fe_w = rho_fe*sales_share
		g rho_fe2 = rho_fe^2
		g rho_fe2_w = rho_fe2*sales_share
	
		g sig_rho_nfe_w = sigma*rho_nfe*sales_share
		g sig_rho_fe_w = sigma*rho_fe*sales_share 
		
		g sig_rho_nfe = sigma*rho_nfe
		g sig_rho_fe = sigma*rho_fe 
		
		
		g wy_$mu = $mu * sales_share
		g wm_$mu = $mu * M_share
		g hwy_$mu = (1/ $mu ) * sales_share

		
		rename b_nfe s_elast_nfe
		rename b_fe s_elast_fe

			bysort industry fyear: egen y_95 =pctile(Y_nom ) , p(95)
		g top_5_share= sales_share *(Y_nom>=y_95 & Y_nom!=.)


		collapse(sum) top_5_share sigma_w rho_nfe_w rho_fe_w sig_rho_nfe_w sig_rho_fe_w wy_$mu hwy_$mu wm_$mu Y_nom labour M_nom sigma2_w rho_fe2_w sales_share (max) max_sigma_w=sigma_w  max_rho_nfe_w=rho_nfe_w max_rho_fe_w=rho_fe_w  max_sig_rho_nfe_w=sig_rho_nfe_w max_sig_rho_fe_w=sig_rho_fe_w max_wy_$mu =wy_$mu max_hwy_$mu = hwy_$mu max_wm_$mu = wm_$mu max_Y_share = sales_share max_M_share= M_share max_labour_share = L_share (count) firmid  (mean) $mu s_elast_nfe s_elast_fe sigma rho_nfe rho_fe sig_rho_nfe sig_rho_fe (p50) med_$mu = $mu med_sigma = sigma, by(fyear $ind )
 
		g cov_nfe = sig_rho_nfe_w-sigma_w*rho_nfe_w
		g cov_fe = sig_rho_fe_w-sigma_w*rho_fe_w
		
		g var_sigma = sigma2_w-sigma_w^2
		g var_rho_fe = rho_fe2_w-rho_fe_w^2
		
		g sd_sigma = var_sigma^(1/2)
		g sd_rho_fe = var_rho_fe^(1/2)
		
		g cor_fe = cov_fe/(sd_sigma*sd_rho_fe)
		
		replace hwy_$mu = 1/hwy_$mu
		
		save "`outputs'\Ind_files\div_pass_ind_`i'_trim_`trim'_`mu'_tv.dta"  , replace  
		restore
	}
	preserve
	levelsof divno , local(ind_names)

	clear
	foreach i in   `ind_names' {
		capture append using "`outputs'\Ind_files\div_pass_ind_`i'_trim_`trim'_`mu'_tv.dta"
		capture erase using "`outputs'\Ind_files\div_pass_ind_`i'_trim_`trim'_`mu'_tv.dta"
	}
	save "`outputs'\div_pass_trim_`trim'_`mu'_2024_tv.dta", replace
	restore

		*** Industry level regressions for superelasticity
	
	levelsof industry , local(indus_names)

	foreach i in   `indus_names' {
	
		
		preserve 

		drop if $ind != `i'
	
		** Int based
		g sigma = $mu /( $mu -1) 

		drop if $mu <0
		if "`trim'" =="i" {
			bysort industry: egen mu99 =pctile( $mu ) , p(99)
			drop if $mu > mu99 
			bysort industry: egen sigma99 =pctile( sigma ) , p(99)
			drop if sigma > sigma99
		}
		
		if "`trim'" =="i_w" {
			bysort industry: egen mu99 =pctile( $mu ) , p(99)
			replace $mu = mu99 if $mu >	mu99 & $mu !=.
			bysort industry: egen sigma99 =pctile( sigma ) , p(99)
			replace sigma = sigma99 if sigma >	sigma99 & sigma !=.
		}
	
	
	if "`trim'" =="iy" {
			bysort fyear industry: egen mu99y =pctile($mu ) , p(99)
			drop if $mu >	mu99y
			bysort industry: egen sigma99 =pctile( sigma ) , p(99)
			drop if sigma > sigma99
		}
		
		if "`trim'" =="iy_w" {
			bysort fyear industry: egen mu99y =pctile($mu ) , p(99)
			replace $mu = mu99y if $mu >	mu99y & $mu !=.
			bysort industry: egen sigma99 =pctile( sigma ) , p(99)
			replace sigma = sigma99 if sigma >	sigma99 & sigma !=.
		}

		if "`trim'" =="i95" {
			bysort industry: egen mu95 =pctile( $mu ) , p(95)
			drop if $mu >	mu95 
			bysort industry: egen sigma95 =pctile( sigma ) , p(95)
			drop if sigma > sigma95
		}
		
		if "`trim'" =="i95_w" {
			bysort industry: egen mu95 =pctile( $mu ) , p(95)
			replace $mu = mu95 if $mu >	mu95 & $mu !=.
			bysort industry: egen sigma95 =pctile( sigma ) , p(95)
			replace sigma = sigma95 if sigma >	sigma95 & sigma !=.
		}
	
	
	
		if "`trim'" =="iy95" {
			bysort industry fyear: egen mu95y =pctile($mu ) , p(95)
			drop if $mu > mu95y 
			bysort fyear industry: egen sigma95 =pctile( sigma ) , p(95)
			drop if sigma > sigma95
		}
		
			
		if "`trim'" =="iy95_w" {
			bysort industry fyear: egen mu95y =pctile($mu ) , p(95)
			replace $mu = mu95y if $mu >	mu95y & $mu !=.
			bysort fyear industry: egen sigma95 =pctile( sigma ) , p(95)
			replace sigma = sigma95 if sigma >	sigma95 & sigma !=.
		}
		
		drop if $mu <=1
		** extra sigma level constraint for crazy high
		egen mu99_t =pctile( $mu ) , p(99)
		replace $mu = mu99_t if $mu >	2*mu99_t & $mu !=.
 		egen sigma99_t =pctile( $mu ) , p(99)
		replace sigma = mu99_t if sigma >	2*sigma99_t & sigma !=.
	
 
 
		bysort fyear : egen tot_y = total(Y_nom)
		bysort fyear : egen tot_l = total(labour)
		bysort fyear : egen tot_m = total(M_nom)



		g sales_share = Y_nom/tot_y
		g lsales_share = log(sales_share)
		
		
		
		g M_share = M_nom/tot_m
		g L_share = labour/tot_l




		g fmu = 1/$mu +log(1-1/$mu )
		xtset firmid fyear
 
 ** base

 summari fyear
 local max = `r(max)'
 local min = `r(min)'
	local j = `max'-2
	
	g a_nfe = .
	g b_nfe = .
	g a_fe = .
	g b_fe = .
 forvalues q = `min'/`j' {
		capture reghdfe fmu lsales_share if fyear>=`q' & fyear<=`q'+2, vce(cluster firmid) a(i.fyear##i.industry)
		if _rc ==0 {
		replace a_nfe = _b[_cons] if fyear==`q'
		replace b_nfe = _b[lsales_share] if fyear==`q'
		}
		capture reghdfe fmu lsales_share if fyear>=`q' & fyear<=`q'+2, vce(cluster firmid) a(i.fyear##i.industry firmid )
		if _rc ==0 {
		replace a_fe = _b[_cons] if fyear==`q'
		replace b_fe = _b[lsales_share] if fyear==`q'
		}
 }


		foreach var in nfe fe    {
			g rho_`var' = 1/(1+ $mu *b_`var')
		}

 
		g sigma_w = sigma*sales_share
		g sigma2 = sigma^2
		g sigma2_w = sigma2*sales_share
		
		g rho_nfe_w = rho_nfe*sales_share
		g rho_fe_w = rho_fe*sales_share
		g rho_fe2 = rho_fe^2
		g rho_fe2_w = rho_fe2*sales_share
	
		g sig_rho_nfe_w = sigma*rho_nfe*sales_share
		g sig_rho_fe_w = sigma*rho_fe*sales_share 
		
		g sig_rho_nfe = sigma*rho_nfe
		g sig_rho_fe = sigma*rho_fe 
		
		
		g wy_$mu = $mu * sales_share
		g wm_$mu = $mu * M_share
		g hwy_$mu = (1/$mu ) * sales_share
		rename b_nfe s_elast_nfe
		rename b_fe s_elast_fe

	bysort industry fyear: egen y_95 =pctile(Y_nom ) , p(95)
		g top_5_share= sales_share *(Y_nom>=y_95 & Y_nom!=.)

		collapse(sum) top_5_share sigma_w rho_nfe_w rho_fe_w sig_rho_nfe_w sig_rho_fe_w wy_$mu hwy_$mu wm_$mu Y_nom labour M_nom sigma2_w rho_fe2_w sales_share (max) max_sigma_w=sigma_w  max_rho_nfe_w=rho_nfe_w max_rho_fe_w=rho_fe_w  max_sig_rho_nfe_w=sig_rho_nfe_w max_sig_rho_fe_w=sig_rho_fe_w max_wy_$mu =wy_$mu max_hwy_$mu =hwy_$mu max_wm_$mu = wm_$mu max_Y_share = sales_share max_M_share= M_share max_labour_share = L_share (count) firmid  (mean) $mu s_elast_nfe s_elast_fe sigma rho_nfe rho_fe sig_rho_nfe sig_rho_fe (p50) med_$mu = $mu med_sigma = sigma, by(fyear $ind )
 
		g cov_nfe = sig_rho_nfe_w-sigma_w*rho_nfe_w
		g cov_fe = sig_rho_fe_w-sigma_w*rho_fe_w
		
		g var_sigma = sigma2_w-sigma_w^2
		g var_rho_fe = rho_fe2_w-rho_fe_w^2
		
		g sd_sigma = var_sigma^(1/2)
		g sd_rho_fe = var_rho_fe^(1/2)
		
		g cor_fe = cov_fe/(sd_sigma*sd_rho_fe)
		
		replace hwy_$mu = 1/ hwy_$mu
		save "`outputs'\Ind_files\pass_ind_`i'_trim_`trim'_`mu'_tv.dta"  , replace  
		restore
	}
	preserve
	levelsof industry , local(indus_names)

	clear
	foreach i in   `indus_names' {
		capture append using "`outputs'\Ind_files\pass_ind_`i'_trim_`trim'_`mu'_tv.dta"
		capture erase using "`outputs'\Ind_files\pass_ind_`i'_trim_`trim'_`mu'_tv.dta"
	}
	save "`outputs'\pass_trim_`trim'_`mu'_2024_tv.dta", replace

	restore
	
}

}	

